// CRollupCtrl & CRollupHeader
// (c) 2002 by FoRcHa (a.k.a. NO)  [seppforcher38@hotmail.com]
//
// I would appreciate a notification of any bugs or bug fixes to help the control grow.
///////////////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
#include "otherfunctions.h"
#include "RollupCtrl.h"
#include "TransferWnd.h"
#include "DeferPos.h"
#include ".\rollupctrl.h"
#include "..\..\opcodes.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRollupHeader
CRollupHeader::CRollupHeader()
{
//dlarge Colours
	m_crBackColor = RGB(100,100,100);
	m_crTextColor = RGB(255, 255, 255);
//dlarge end
	m_crBorderColor = GetSysColor(COLOR_WINDOWFRAME);
			
	m_cfTextFont.CreateFont(-10,0,0,0,0,0,0,0,0,1,2,1,34,_T("MS Sans Serif"));
	m_cpBorderPen.CreatePen(PS_SOLID, 1, m_crBorderColor);
	m_cpArrowPen.CreatePen(PS_SOLID, 1, m_crTextColor);
	
	m_MemDC.m_hDC = NULL;
	m_MemBMP.m_hObject = NULL;
	m_pOldMemBMP = NULL;

	m_rClientRect = m_rArrowRect = m_rTextRect = CRect(0,0,0,0);

	m_bInit = TRUE;	
	m_bExpanded = FALSE;

	m_iHeight = RUP_HEADERHEIGHT;
}

CRollupHeader::~CRollupHeader()
{
	if(m_MemDC.m_hDC)
	{
		if(m_pOldMemBMP)
			m_MemDC.SelectObject(m_pOldMemBMP);
	}	
}


BEGIN_MESSAGE_MAP(CRollupHeader, CWnd)
	//{{AFX_MSG_MAP(CRollupHeader)
	ON_WM_PAINT()
	ON_WM_LBUTTONUP()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	ON_WM_LBUTTONDBLCLK()
	ON_WM_SYSCOLORCHANGE()
	ON_WM_RBUTTONUP()
	ON_WM_ERASEBKGND()
ON_WM_ERASEBKGND()
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CRollupHeader message handlers

void CRollupHeader::OnPaint() 
{
	CPaintDC dc(this);
	CRect rClientRect;
	
	if(m_bInit)
	{
		GetClientRect(&rClientRect);
		CreateMemDC(&dc, &rClientRect);

		m_rClientRect = rClientRect;
		m_rArrowRect = rClientRect;
		m_rArrowRect.right = m_rArrowRect.left + m_iHeight;
		m_rArrowRect.DeflateRect(2,2);
		m_cpArrowPoint.x = m_rArrowRect.left + 5;
		m_cpArrowPoint.y = m_rArrowRect.top + 5;
		m_rTextRect = rClientRect;
		m_rTextRect.DeflateRect(m_iHeight + 2, 2, 4+5, 2);	// space(s) between border and text

		m_bInit = FALSE;
	}

	CPen *pOldPen = m_MemDC.SelectObject(&m_cpBorderPen);
	COLORREF crOldTxtColor = m_MemDC.SetTextColor(m_crTextColor);
	COLORREF crOldBckColor = m_MemDC.SetBkColor(m_crBackColor);
	int iOldBkMode = m_MemDC.SetBkMode(OPAQUE);

	m_MemDC.FillSolidRect(m_rClientRect, m_crBackColor);
	m_MemDC.MoveTo(m_rClientRect.left, m_rClientRect.top);
	m_MemDC.LineTo(m_rClientRect.right, m_rClientRect.top);

#ifndef NEW_LOOK
	m_MemDC.MoveTo(m_rClientRect.left, m_rClientRect.bottom-1);
	m_MemDC.LineTo(m_rClientRect.right, m_rClientRect.bottom-1);

	m_MemDC.MoveTo(m_rClientRect.left, m_rClientRect.top);
	m_MemDC.LineTo(m_rClientRect.left, m_rClientRect.bottom);

	m_MemDC.MoveTo(m_rClientRect.right-1, m_rClientRect.top);
	m_MemDC.LineTo(m_rClientRect.right-1, m_rClientRect.bottom);
#endif NEW_LOOK

	CPoint cpArrowPt(m_cpArrowPoint);
	if(m_bExpanded)
		cpArrowPt.y+=3;
	else
		cpArrowPt.x++;
	
	DrawArrow(&m_MemDC, &cpArrowPt, m_bExpanded);
	
	CFont *pOldFont = m_MemDC.SelectObject(&m_cfTextFont);
	m_MemDC.DrawText(m_strRightText, m_rTextRect,
		DT_RIGHT | DT_NOPREFIX | DT_NOCLIP | DT_SINGLELINE | DT_VCENTER | DT_END_ELLIPSIS);
	m_MemDC.DrawText(m_strLeftText, m_rTextRect,
		DT_LEFT | DT_NOPREFIX | DT_NOCLIP | DT_SINGLELINE | DT_VCENTER | DT_END_ELLIPSIS);

	dc.BitBlt(m_rClientRect.left, m_rClientRect.top, m_rClientRect.Width(), m_rClientRect.Height(),
				&m_MemDC, 0, 0, SRCCOPY);

	m_MemDC.SelectObject(pOldFont);
	m_MemDC.SetBkMode(iOldBkMode);
	m_MemDC.SetBkColor(crOldBckColor);
	m_MemDC.SetTextColor(crOldTxtColor);
	m_MemDC.SelectObject(pOldPen);
}

void CRollupHeader::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if(point.x >= m_rArrowRect.left && point.x <= m_rArrowRect.right &&
	   point.y >= m_rArrowRect.top  && point.y <= m_rArrowRect.bottom)
	{
		m_bExpanded = !m_bExpanded;
		Invalidate();
		GetParent()->SendMessage(WM_COMMAND, USRMSG_STATECHANGED, (LPARAM)m_hWnd);
	}
	
	CWnd::OnLButtonUp(nFlags, point);
}

void CRollupHeader::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	if(point.x >= m_rTextRect.left && point.x <= m_rTextRect.right &&
		point.y >= m_rTextRect.top && point.y <= m_rTextRect.bottom)
	{
		m_bExpanded = !m_bExpanded;
		Invalidate();
		GetParent()->SendMessage(WM_COMMAND, USRMSG_STATECHANGED, (LPARAM)m_hWnd);
	}

	CWnd::OnLButtonDblClk(nFlags, point);
}

void CRollupHeader::OnRButtonUp(UINT nFlags, CPoint point)
{
	GetParent()->SendMessage(WM_COMMAND, USRMSG_RIGHTCLICK, (LPARAM)m_hWnd);
	CWnd::OnRButtonUp(nFlags, point);
}

void CRollupHeader::OnSize(UINT nType, int cx, int cy) 
{
	CWnd::OnSize(nType, cx, cy);
	m_bInit = TRUE;
}

void CRollupHeader::OnSysColorChange()
{
	CWnd::OnSysColorChange();
//dlarge Colours
	m_crBackColor = RGB(100,100,100);
	m_crTextColor = RGB(255, 255, 255);
//dlarge end
	m_crBorderColor = GetSysColor(COLOR_WINDOWFRAME);

	if(m_cpBorderPen.GetSafeHandle())
		m_cpBorderPen.DeleteObject();
	m_cpBorderPen.CreatePen(PS_SOLID, 1, m_crBorderColor);
	if(m_cpArrowPen.GetSafeHandle())
		m_cpArrowPen.DeleteObject();
	m_cpArrowPen.CreatePen(PS_SOLID, 1, m_crTextColor);
	Invalidate();
}

void CRollupHeader::DrawArrow(CDC* pDC, CPoint* pTopLeft, bool bDown)
{
	CPen *pOldPen;
	pOldPen = pDC->SelectObject(&m_cpArrowPen);
	
	if(bDown)
	{
		int xs = pTopLeft->x;
		int xe = pTopLeft->x + 7;
		
		for(int y = pTopLeft->y; y < pTopLeft->y + 4; y++)
		{	
			pDC->MoveTo(xs,y);
			pDC->LineTo(xe,y);
			xs++;
			xe--;
		}
	}
	else
	{
		int ys = pTopLeft->y;
		int ye = pTopLeft->y + 7;

		for(int x = pTopLeft->x; x < pTopLeft->x + 4; x++)
		{
			pDC->MoveTo(x,ys);
			pDC->LineTo(x,ye);
			ys++;
			ye--;
		}
	}

	pDC->SelectObject(pOldPen);
}

BOOL CRollupHeader::OnEraseBkgnd(CDC* /*pDC*/)
{
	return FALSE;
}


/////////////////////////////////////////////////////////////////////////////
// CRollupCtrl

CRollupCtrl::CRollupCtrl()
: m_iHeaderHeight(0)
{
	m_iHeaderHeight = RUP_HEADERHEIGHT;
	m_iExpandedItems = 0;
	m_bExpandedItems = 0x00;
}

CRollupCtrl::~CRollupCtrl()
{
	int iCount = (int)m_List.GetSize();
	for(int i = 0; i < iCount; i++)
	{
		RollupEntry *pEntry = m_List.GetAt(i);
		if(pEntry)
		{	
			if(pEntry->pHeader)
			{
				if(pEntry->pHeader->m_hWnd)
					pEntry->pHeader->DestroyWindow();
				delete pEntry->pHeader;
			}
			if(pEntry->pGripper)
			{
				if(pEntry->pGripper->m_hWnd)
					pEntry->pGripper->DestroyWindow();
				delete pEntry->pGripper;
			}
			if(pEntry->pSizes)
				delete [] pEntry->pSizes;
			delete pEntry;
		}
	}

	m_List.RemoveAll();
}


BEGIN_MESSAGE_MAP(CRollupCtrl, CWnd)
	//{{AFX_MSG_MAP(CRollupCtrl)
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CRollupCtrl message handlers
int CRollupCtrl::InsertItem(LPCTSTR strLeft, LPCTSTR strRight, CWnd *pClient, int iIndex, bool bExpanded)
{
	ASSERT(pClient != NULL);
	ASSERT(pClient->m_hWnd != NULL);
	
	CRollupHeader *pHeader = new CRollupHeader;
	pHeader->Create(NULL, NULL, WS_CHILD | WS_VISIBLE, CRect(0,0,0,0), this, rand());
	pHeader->SetHeight(m_iHeaderHeight);
	pHeader->Expand(bExpanded);
	pHeader->SetLeftText(strLeft);
	pHeader->SetRightText(strRight);
	
	CRollupGripper *pGripper = new CRollupGripper;
	pGripper->Create(NULL, NULL, WS_CHILD, CRect(0,0,60,15), this, rand());
	
	RollupEntry *pEntry = new RollupEntry;
	pEntry->pHeader	 = pHeader;
	pEntry->pGripper = pGripper;
	pEntry->pClient  = pClient;	
	pEntry->pSizes	 = new double[10];			// max. 8 items
	pEntry->iMinHeight = RUP_ENTRYMINHEIGHT;
	
	int iPos;
	if(iIndex < 0)
		iPos = (int)m_List.Add(pEntry);
	else
	{
		m_List.InsertAt(iIndex, pEntry);
		iPos = iIndex;
	}

	if(bExpanded)
	{	
		int bEntry = 0x01 << iPos;
		m_bExpandedItems |= bEntry;
		m_iExpandedItems++;
	}

	return iPos;
}

void CRollupCtrl::OnPaint() 
{	
	CPaintDC dc(this);
	
	CRect rClient;
	GetClientRect(&rClient);
	
	int iExpandedItems = 0;
	int iYpos = 0;
	int iCount = (int)m_List.GetSize();

	CDeferPos dp(iCount * 3 - 1);

	for(int i = 0; i < iCount; i++)
	{	
		RollupEntry *pEntry = m_List.GetAt(i);
		ASSERT(pEntry != NULL);
	
		dp.MoveWindow(pEntry->pHeader, rClient.left, rClient.top + iYpos,
						rClient.Width(), m_iHeaderHeight, TRUE); 
	
		iYpos += m_iHeaderHeight;

		if(pEntry->pHeader->IsExpanded())
		{	
			iExpandedItems++;

			CRect rFillRect = rClient;
			rFillRect.top += iYpos;

			double dblHeight = (rClient.Height() - (m_iHeaderHeight * m_List.GetSize() + RUP_BORDERSIZES * m_iExpandedItems)) * pEntry->pSizes[m_bExpandedItems] / 100.0;
			int iHeight = static_cast<int>(dblHeight);
			if(dblHeight - iHeight >= 0.5)
				iHeight++;
			
			bool bShowGripper;
			
			if(i >= iCount-1) // lastitem?
			{
				iHeight += RUP_BORDERSIZES;

				if(pEntry->pGripper->IsWindowVisible())
				{
					pEntry->pGripper->ShowWindow(SW_HIDE);
					pEntry->pGripper->EnableWindow(FALSE);
				}
				bShowGripper = false;
			}
			else
			{	
				if(m_iExpandedItems > iExpandedItems)
				{
					iHeight -= RUP_GRIPPERHEIGHT + RUP_BORDERSIZES;
					bShowGripper = true;
				}
				else
				{
					bShowGripper = false;
					if(pEntry->pGripper->IsWindowVisible())
					{
						pEntry->pGripper->ShowWindow(SW_HIDE);
						pEntry->pGripper->EnableWindow(FALSE);
					}
				}
			}
	
			CRect rPClient = rClient;
			rPClient.top += iYpos;
			rPClient.bottom = rPClient.top + iHeight - 1;
			CWnd *pClientParent = pEntry->pClient->GetParent();
			if(pClientParent != NULL && pClientParent != this)
			{
				ClientToScreen(&rPClient);
				pClientParent->ScreenToClient(&rPClient);
			}

			pEntry->pClient->EnableWindow();
			dp.MoveWindow(pEntry->pClient, rPClient.left, rPClient.top, rPClient.Width(), rPClient.Height(), TRUE);
			pEntry->pClient->ShowWindow(SW_SHOW); // need OnShowWindow in CInfoListCtrl
			
			CRect rFill = rClient;
			rFill.top = rPClient.bottom;

			iYpos += iHeight + RUP_BORDERSIZES;
			
			if(bShowGripper)
			{
				dp.SetWindowPos(pEntry->pGripper, NULL, 
								rClient.left + rClient.Width() / 2 - RUP_GRIPPERWIDTH / 2,
								rClient.top + iYpos, RUP_GRIPPERWIDTH, RUP_GRIPPERHEIGHT, 
								SWP_NOZORDER|SWP_NOSIZE|SWP_SHOWWINDOW);
				pEntry->pGripper->EnableWindow();

				iYpos += RUP_GRIPPERHEIGHT + RUP_BORDERSIZES;
			}

			rFill.bottom = rClient.top + iYpos;
			dc.FillSolidRect(rFill, GetSysColor(COLOR_BTNFACE));
		}
		else
		{
			if(pEntry->pGripper->IsWindowEnabled())
				pEntry->pGripper->EnableWindow(FALSE);
			if(pEntry->pGripper->IsWindowVisible())
				pEntry->pGripper->ShowWindow(SW_HIDE);
			if(pEntry->pClient->IsWindowEnabled())
				pEntry->pClient->EnableWindow(FALSE);
			if(pEntry->pClient->IsWindowVisible())
				pEntry->pClient->ShowWindow(SW_HIDE);
		}
	}

	if(iExpandedItems == 0)
	{
		CRect rFill = rClient;
		rFill.top = rClient.top + iYpos;
		dc.FillSolidRect(rFill, GetSysColor(COLOR_BTNFACE));
	}
}

void CRollupCtrl::OnSize(UINT nType, int cx, int cy) 
{
	CWnd::OnSize(nType, cx, cy);
}

BOOL CRollupCtrl::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	switch(wParam)
	{
		case USRMSG_STATECHANGED:
		{		
			ChildStateChanged((HWND)lParam, true);
			break;
		}
		case USRMSG_GRIPPERMOVE:
		{
			if(Recalc((HWND)lParam))
				Invalidate();			
			break;
		}
		case USRMSG_RIGHTCLICK:
		{
		//	if(m_List.GetAt(2)->pHeader->m_hWnd == (HWND)lParam)
		//		GetParent()->SendMessage(WM_COMMAND, USRMSG_SWITCHEXTLIST, 0);
			/*else */if(m_List.GetAt(1)->pHeader->m_hWnd == (HWND)lParam)
				GetParent()->SendMessage(WM_COMMAND, USRMSG_SWITCHUPLOADLIST, 0);
			else if(m_List.GetAt(0)->pHeader->m_hWnd == (HWND)lParam)
				GetParent()->SendMessage(WM_COMMAND, USRMSG_SWITCHDOWNLOADLIST, 0);
			//else if(m_List.GetAt(0)->pHeader->m_hWnd == (HWND)lParam)
			//	GetParent()->SendMessage(WM_COMMAND, USRMSG_CLEARCOMPLETED, 0);
		}
		default: 
		{
			//GetParent()->PostMessage(WM_COMMAND, wParam, lParam);
			break;
		}
	}
	
	return CWnd::OnCommand(wParam, lParam);
}

int CRollupCtrl::SetText(unsigned uiItem, CString strText, bool bLeft)
{
	if (uiItem >= static_cast<unsigned>(m_List.GetSize()))
		return -1;
	
	if(bLeft)
		m_List.GetAt(uiItem)->pHeader->SetLeftText(strText);
	else
		m_List.GetAt(uiItem)->pHeader->SetRightText(strText);

	return 0;
}

int CRollupCtrl::SetHeaderColor(unsigned uiItem, int iColor, COLORREF crColor)
{
	if (uiItem >= static_cast<unsigned>(m_List.GetSize()))
		return -1;

	switch(iColor%3)
	{
		case 0:	m_List.GetAt(uiItem)->pHeader->SetBackColor(crColor); break;
		case 1:	m_List.GetAt(uiItem)->pHeader->SetTextColor(crColor); break;
		case 2:	m_List.GetAt(uiItem)->pHeader->SetBorderColor(crColor); break;
	}

	return 0;
}

BOOL CRollupCtrl::OnEraseBkgnd(CDC* /*pDC*/) 
{
	//CRect r;
	//GetClientRect(&r);
	//pDC->FillSolidRect(r, GetSysColor(COLOR_BTNFACE));
	return FALSE;
}

int CRollupCtrl::SetItemHeights(unsigned uiItem, double *pHeights, int iCount)
{
	if ((uiItem >= static_cast<unsigned>(m_List.GetSize())) || (iCount > 10))
		return -1;

	RollupEntry *pEntry = m_List.GetAt(uiItem);
	memcpy(pEntry->pSizes, pHeights, iCount * sizeof(double));

	return 0;
}

int CRollupCtrl::Recalc(HWND hWnd)
{
	int iCount = (int)m_List.GetSize();
	for(int i = 0; i < iCount; i++)
	{			
		RollupEntry *pEntry = m_List.GetAt(i);
		if(pEntry->pGripper->m_hWnd == hWnd)
		{	
			CRect rClientRect;
			GetClientRect(&rClientRect);
						
			RollupEntry *pNextEntry = m_List.GetAt(i+1);		// ToDO: Error-Handling
			if(!pNextEntry->pHeader->IsExpanded())
			{
				if(i+2 < iCount)
					pNextEntry = m_List.GetAt(i+2);
				else
					return 0;
			}
			
			int iMove = pEntry->pGripper->GetLastMove();
			double dblTotal = pEntry->pSizes[m_bExpandedItems] + pNextEntry->pSizes[m_bExpandedItems];

			// get window heights:
			double dblSize = static_cast<double>(rClientRect.Height() - (m_iHeaderHeight * m_List.GetSize() + RUP_BORDERSIZES * m_iExpandedItems));
			double dblHeight1 = dblSize / 100.0 * pEntry->pSizes[m_bExpandedItems] - RUP_GRIPPERHEIGHT - RUP_BORDERSIZES;
			double dblHeight2 = dblSize / 100.0 * pNextEntry->pSizes[m_bExpandedItems];
				
			if(pNextEntry->pHeader->IsExpanded() && i+1 < iCount-1)
				dblHeight2 -= (RUP_GRIPPERHEIGHT + RUP_BORDERSIZES);
			
			// change the heights:
			if(iMove >= 0)
			{
				dblHeight1 -= iMove;
				if(dblHeight1 <= pEntry->iMinHeight)
				{	
					iMove -= pEntry->iMinHeight - (int)dblHeight1;
					dblHeight1 = pEntry->iMinHeight;
				}												
				dblHeight2 += iMove;
			}
			else
			{
				iMove = -iMove;
				dblHeight2 -= iMove;
				if(dblHeight2 <= pNextEntry->iMinHeight)
				{
					iMove -= pNextEntry->iMinHeight - (int)dblHeight2;
					dblHeight2 = pNextEntry->iMinHeight;
				}
				dblHeight1 += iMove;
			}

			if(pNextEntry->pHeader->IsExpanded() && i+1 < iCount-1)
				dblHeight2 += RUP_GRIPPERHEIGHT + RUP_BORDERSIZES;
			// calc the percentages
			pEntry->pSizes[m_bExpandedItems] = (dblHeight1 + RUP_GRIPPERHEIGHT+RUP_BORDERSIZES) / dblSize * 100.0;
			pNextEntry->pSizes[m_bExpandedItems] = dblTotal - pEntry->pSizes[m_bExpandedItems];

			if(pEntry->pSizes[m_bExpandedItems] < 10)	// should be changed sometime
			{
				pNextEntry->pSizes[m_bExpandedItems] -= (10-pEntry->pSizes[m_bExpandedItems]);
				pEntry->pSizes[m_bExpandedItems] = 10;
			}
		}
	}

	return 1;
}

int CRollupCtrl::SetItemClient(unsigned uiItem, CWnd *pClient)
{	
	if (uiItem >= static_cast<unsigned>(m_List.GetSize()))
		return -1;

	m_List.GetAt(uiItem)->pClient = pClient;
	return 0;
}

CWnd* CRollupCtrl::GetItemClient(unsigned uiItem)
{
	if (uiItem >= static_cast<unsigned>(m_List.GetSize()))
		return NULL;

	return m_List.GetAt(uiItem)->pClient;
}

RollupEntry* CRollupCtrl::GetItem(unsigned uiItem)
{
	if (uiItem >= static_cast<unsigned>(m_List.GetSize()))
		return NULL;

	return m_List.GetAt(uiItem);
}

int CRollupCtrl::ExpandItem(unsigned uiItem, bool bExpand)
{
	if (uiItem >= static_cast<unsigned>(m_List.GetSize()))
		return -1;
	
	RollupEntry *pEntry = m_List.GetAt(uiItem);

	if (pEntry->pHeader->IsExpanded() != bExpand)
	{
		pEntry->pHeader->Expand(bExpand, false);
		ChildStateChanged(pEntry->pHeader->m_hWnd, false);
	}
	return 0;
}

void CRollupCtrl::ChildStateChanged(HWND hChild, bool bInvalidate)
{
	int iCount = (int)m_List.GetSize();
	for(int i = 0; i < iCount; i++)
	{	
		RollupEntry *pEntry = m_List.GetAt(i);
		if(pEntry->pHeader->m_hWnd == hChild)
		{					
			int bEntry = 0x01 << i;

			if(pEntry->pHeader->IsExpanded())
			{	
				m_bExpandedItems |= bEntry;
				m_iExpandedItems++;
			}					
			else
			{	
				m_bExpandedItems &= ~bEntry;
				m_iExpandedItems--;
			}
			break;
		}
	}

	if(bInvalidate)
		Invalidate();
}

// redirect notify messages to the owner
BOOL CRollupCtrl::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
	CWnd *pParent = GetParent();

	if(pParent)
	{
		*pResult = pParent->SendMessage(WM_NOTIFY, wParam, lParam);
		return TRUE;
	}
	return CWnd::OnNotify(wParam, lParam, pResult);
}
